/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.util.Calendar;
import java.util.Date;

class DisplayFilter {
    private static final String CLASS_NAME = "[DisplayFilter] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String MSG_ALL = "XTIMB1TI5.STRING";
    private static final String MSG_DAY = "XTIMB1TI6.STRING";
    private static final String MSG_DAYS = "XTIMB1TI7.STRING";
    private static final String MSG_WEEK = "XTIMB1TI8.STRING";
    private static final String MSG_WEEKS = "XTIMB1TI9.STRING";
    private static final String MSG_MONTH = "XTIMB1TIA.STRING";
    private static final String MSG_MONTHS = "XTIMB1TIB.STRING";
    private int amount;
    private Types range;

    public DisplayFilter(int amount, Types range) {
        if (amount <= 0 || range == null) {
            throw new IllegalArgumentException("Illegal paramater");
        }
        this.amount = amount;
        this.range = range;
    }

    public int getAmount() {
        return this.amount;
    }

    public Types getRange() {
        return this.range;
    }

    public Date getDisplayDelta(Date current) {
        Date result = null;
        if (this.range != Types.ALL) {
            UserContext userContext = UserContext.getCurrentUserContext();
            Calendar calendar = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
            calendar.setTime(current);
            if (this.range == Types.DAYS) {
                calendar.add(5, this.amount);
                result = calendar.getTime();
            } else if (this.range == Types.WEEKS) {
                calendar.add(5, this.amount * 7);
                result = calendar.getTime();
            } else if (this.range == Types.MONTHS) {
                calendar.add(2, this.amount);
                result = calendar.getTime();
            }
        }
        return result;
    }

    public LocalizableText getDisplayString() {
        LocalizableText result = null;
        if (this.range == Types.ALL) {
            result = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_ALL);
        } else if (this.range == Types.DAYS) {
            result = this.amount == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_DAY, new Object[]{"1"}) : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_DAYS, new Object[]{new Integer(this.amount)});
        } else if (this.range == Types.WEEKS) {
            result = this.amount == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_WEEK, new Object[]{"1"}) : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_WEEKS, new Object[]{new Integer(this.amount)});
        } else if (this.range == Types.MONTHS) {
            result = this.amount == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_MONTH, new Object[]{"1"}) : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_MONTHS, new Object[]{new Integer(this.amount)});
        }
        return result;
    }

    public String toString() {
        return this.getDisplayString().toString();
    }

    public static class Types {
        public static final Types ALL = new Types(1);
        public static final Types DAYS = new Types(2);
        public static final Types WEEKS = new Types(3);
        public static final Types MONTHS = new Types(4);
        private int value;

        private Types(int value) {
            this.value = value;
        }
    }
}

